package GUI;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

/**
 * @author kaiooliveira
 *
 */
public class janelaCadastroProgresso extends JFrame {
	
	private static String arqEstabelecimentos;
	private static String arqOpinioes;
	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JLabel lblSplash = null;
	private JProgressBar prbProgresso = null;
	private Timer timer = null;
	
	/**
	 * Construtor da janela
	 * @param rest
	 * 		caminho do arquivo
	 * @param opini
	 * 		caminho do arquivo
	 */
	public janelaCadastroProgresso(String rest, String opini) {
		super();
		this.arqEstabelecimentos = rest;
		this.arqOpinioes = opini;
		initialize();
	}
	
	/**
	 * inicializa os componentes da janela
	 */
	private void initialize() {
		this.setSize(613, 414);
		this.setContentPane(getJContentPane());
		this.setTitle("Garfo de Ouro - JCK");
		
		timer = new Timer(30, new ActionListener() {
			private int step = 0;
			
			@Override
			public void actionPerformed(ActionEvent e) {
				step++;
				prbProgresso.setValue(step);
				if (step == 100) {
					janelaCadastroProgresso.this.dispose();
					
					new janelaCadastroConcluido(arqEstabelecimentos, arqOpinioes).setVisible(true);
				}
			}
		});
		timer.start();
	}
	
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			lblSplash = new JLabel();
			lblSplash.setFont((new java.awt.Font("Lucida Grande", 0, 20)));
			lblSplash.setText("Cadastrando Usuários...");
			lblSplash.setHorizontalAlignment(SwingConstants.CENTER);
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(lblSplash, BorderLayout.CENTER);
			jContentPane.add(getPrbProgresso(), BorderLayout.SOUTH);
		}
		return jContentPane;
	}
	
	private JProgressBar getPrbProgresso() {
		if (prbProgresso == null) {
			prbProgresso = new JProgressBar();
		}
		return prbProgresso;
	}
	
	public static void main(String[] args) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				
				janelaCadastroProgresso thisClass = new janelaCadastroProgresso(arqEstabelecimentos, arqOpinioes);
			}
		});
	}	
	
}

